package sourceExo1;

import java.util.ArrayList;

/**
 * Banque avec titulaires crées et gérés en externe.
 * Utilise la structure des données ArrayList.
 * Invariant d'état à respecter: les comptes ont des numéros
 * uniques.
 *
 */

public class Banque {
    private String nom;           // nom de la banque
    private int numComptes = 1;   // Prochain numero à pour nouveau compte
    private  ArrayList<Compte> lesComptes; // les comptes de la banque
    /**
     * Constructeur
     * @param n nom de la banque
     */
    public Banque(String n){
	nom =n;
	lesComptes = new ArrayList<Compte>();
    }

    /** 
     * Crée un nouveau compte en lui attribuant un nouveau numéro de compte
     * et l'ajoute dans la liste de chacun de ses titulaires, et dans 
     * celle de la banque.
     * Retourne le numero attribué au compte crée.
     * @param tit  liste de titulaires du compte  à créer
     * @param init solde initial du compte à créer
     * @return le  numéro du nouveau compte
     */
    public int creerCompte(Titulaire tit, double init){
	int n = numComptes;
	Compte c = new Compte(n,init);
	lesComptes.add(c);
	tit.ajouterCompte(c);
	return n;
    }
	
    /**
     * Retourne true s'il existe dans la banque un compte de ce numéro.
     */
    public boolean isNumCompte(int n) {
	return false; // A MODIFIER
    }

    /**
     * Retourne la somme des soldes des comptes de la banque.
     */
    public double BilanSoldes() {
	return 0; // A MODIFIER
    }
    /**
     *  Renvoie une chaîne avec le nom de la banque et
     *  tous les comptes de la banque
     */
    public String toString(){
	// A MODIFIER
	return null;
    }

}
