package squelette_librairie;
/**
 * Gestion du stock de livres de la librairie.
 * Invariant d'état: deux objets en stock ne peuvent avoir les mêmes titre ET auteur.
 */
import java.util.ArrayList;
public class StockLivres {

	private ArrayList<Livre> stocklib; // les livres du stock
    /**
     * Constructeur: le stock initial est vide
     */
	public StockLivres(){
		this.stocklib = new ArrayList<Livre>();
	}
    /**
     * Retourne la liste de tous les livres du stock.
     * @return
     */
	public ArrayList<Livre> getStock(){
		return null;  // A MODIFIER
	}

	/**
	 * Retourne la liste de tous les livres trouvés en stock avec le titre t.
	 */
	public ArrayList<Livre> getTousTitre(String t){
		return null;  // A MODIFIER
	}

	/**
	 * Retourne l'indice d'un livre de titre et auteur en paramètre.
	 * Retourne -1 si non trouvé.
	 * @param titre
	 * @param auteur
	 * @return
	 */
	private int indiceTitreAuteur(String titre, String auteur) {
		for (int i=0; i<stocklib.size(); i++){
			if (stocklib.get(i).getTitre().equals(titre) && 
				stocklib.get(i).getAuteur().equals(auteur)) 
			{return i;}
		}
		return -1;
	}
	/**
	 * Retourne le livre en stock correpondant au titre et auteur si trouvé, null sinon.
	 */
	public Livre getTitreAuteur(String titre, String auteur) {
		 // A MODIFIER
		return null;
	}
	/**
	 * Retourne le livre correpondant au titre et auteur de l si trouvé, null sinon.
	 * @param l
	 * @return
	 */
	public Livre getTitreAuteur(Livre l) {
		return getTitreAuteur(l.getTitre(), l.getAuteur());
	}
	/**
	 * Retourne la quantité trouvée en stock pour un livre de mêmes titre et auteur que l.
	 * @param l livre contenant le titre et auteur que l'on cherche.
	 * @return
	 */
	public int getQuantite(Livre l) {
		Livre o = getTitreAuteur(l);
		if (o==null) return 0;
		else return o.getNbExemplaires();
	}
	
	/**
	 * Ajoute un nouveau livre au stock si celui-ci n'y est déjà présent 
	 * (même titre et auteur) auquel cas il additionne les quantité d'exemplaires.
	 * QUESTION 2: Cette méthode ne teste pas l'égalité de prix dans l et le livre en stock.
	 * Faites le!!! Doit on créer une nouvelle sorte d'erreur (exception)?
	 */
	public void ajoutExemplaires(Livre l){
		 // A MODIFIER POUR LA QUESTION 2
		Livre lp=getTitreAuteur(l);
		if (lp==null)
			this.stocklib.add(l);
		else
			lp.ajoutExemplaires(l.getNbExemplaires());
	}
}
