package squelette_librairie;

public class StockError extends RuntimeException {
	private int nbRequis; // nombre demandé (ex: pour une vente)
	private int nbDispo;  // nombre trouvé en stock
	private int codeErr;  // code de l'erreur
	private String [] err = {"Ouvrage non trouvé au catalogue", "Nb d'exemplaires insuffisant"};
	
	
	public StockError( int r, int d) { // Quantité insuffisante
		this.codeErr = 1; this.nbRequis=r; this.nbDispo=d;
	}	
	public StockError() { // Ouvrage inexistant
		this.codeErr = 0;
	}
	public void printErr() {
		System.out.println(" **** Stock error: "+ err[codeErr]+"\n");
		if (codeErr>0) 
			System.out.println(" ==> nombre requis: "+ this.nbRequis+ ", disponible: "+ this.nbDispo);
	}
}
