package squelette_librairie;

public class Livre {
	/** Attributs */
	private String titre;  
	private String auteur;
	private int nbExemplaires;
	private double prix;
	
	/*** Invariant d'état: le nombre d'exemplaires 
	 * et le prix d'un livre sont >=0 **/
	
	/** 
	 * Constructeur
	 * @param t titre
	 * @param a auteur
	 * @throws IllegalArgumentException si le prix ou le nombre
	 * d'exemplaires sont négatifs.
	 */
	public Livre(String t, String a, double p, int n){
		if (p<0 || n<0)
			throw new IllegalArgumentException();
		this.titre =t; this.auteur = a; this.nbExemplaires =n;this.prix=p;
	}
	public Livre(Livre l, int n){
		if (n<0)
			throw new IllegalArgumentException();
		this.titre =l.getTitre(); this.auteur = l.titre; 
		this.nbExemplaires =n;this.prix=l.getPrix();
	}
	/** Accesseurs */
	
	public String getTitre() {
		return titre;
	}	
	public String getAuteur() {
		return auteur;
	}
	public int getNbExemplaires(){
		return nbExemplaires;
	}
	public double getPrix(){
		return prix;
	}
	@Override
	public String toString() {
		return "  Titre= "+this.titre+", Auteur= "+this.auteur+", Prix= "+this.prix+", Exemplaires= "+this.nbExemplaires;
	}
	/** Modificateurs */
	
    /**
     * Ajoute n au nombre d'exemplaires dans ce livre.
     * @throws IllegalArgumentException si n est négatif.
     */
	public void ajoutExemplaires(int n) {
		if (n<0) throw new IllegalArgumentException();
		nbExemplaires= nbExemplaires+n;
	}
	/**
	 * Soustrait n au nombre d'exemplaires de ce livre si le nombre courant
	 * est supérieur ou égal à n et retourne le prix total a payer pour n exemplaires.
	 * @throws IllegalArgumentException si n est négatif.
	 * @throws StockError si le nombre courant est plus petit que n.
	 */
	public double retireExemplaires(int n) {
		if (n<0) throw new IllegalArgumentException();	
		if (this.nbExemplaires>=n) {
			nbExemplaires= nbExemplaires-n;
			return (this.getPrix()*n);
		}
		else
			throw new StockError(n, this.nbExemplaires);
	}
}
