package squelette_librairie;

/**
 * Opérations métier pour l'application librairie.
 */
import java.util.ArrayList;

public class Librairie {
	private StockLivres stock = new StockLivres(); // le stock de la librarie
	private double chiffreVentes = 0; // le chiffre de ventes de la librairie

	/**
	 * Retourne le chiffre courant de ventes.
	 * 
	 * @return
	 */
	public double getChiffreVentes() {
		// A MODIFIER
		return 0;
	}

	/**
	 * Retourne la quantité d'exemplaires trouvés en stock pour cet ouvrage (mêmes
	 * auteur et titre).
	 * 
	 * @param l
	 *            livre dont on cherche un ouvrage de même titre et auteur
	 * @return
	 */
	public int getQuantiteOuvrage(Livre l) {
		// A MODIFIER
		return 0;
	}

	/**
	 * Retourne le livre trouvé en stock de même titre et auteur que l, et null si non trouvé. 
	 * @param l
	 * @return
	 */
	public Livre getOuvrageTitreAuteur(Livre l) {
		return stock.getTitreAuteur(l);
	}

	/**
	 * Enregistre une vente au stock et dans le chiffre de ventes si la
	 * disponibilité en stock est suffisante et retourne le montant total à payer.
	 * 
	 * @param o   ouvrage (titre et auteur à prendre en compte)
	 * @param nb  quantité souhaitée
	 *            
	 * @return total à payer
	 * @throws IllegalArgumentException si nb est négatif
	 * @throws StockErr(0)
	 *             si aucun ouvrage de ce titre et auteur en stock
	 * @throws StockErr(1)
	 *             si l'ouvrage est en stock mais en quantité insuffisante.
	 */
	public double realiseVente(Livre o, int nb) {
		if (nb < 0)
			return 0;   // A MODIFIER
		Livre l = stock.getTitreAuteur(o);
		if (l == null)
			throw new StockError();
		else if (l.getNbExemplaires() < nb) {
			throw new StockError(nb, l.getNbExemplaires());
		} else {
			// A MODIFIER
			return 0;
		}
	}

	/**
	 * Ajoute en stock les exemplaires arrivées pour cet ouvrage. Un nouvel ouvrage
	 * est ajouté au stock si non présent.
	 * 
	 * @param o
	 *            ouvrage contenant la quantité à additionner à celle éventuellement
	 *            en stock.
	 */
	public void ajoutExemplaires(Livre o) {
		stock.ajoutExemplaires(o);
	}
}
