package squelette_librairie;
/**
 * Classe d'interaction textuelle (clavier) avec l'utilisateur.
 */

public class ApplicationTexte {
	private final String [] operation =        // Noms d'opérations à proposer
		{"Chercher un ouvrage", "Arrivée d'un ouvrage",
		 "Acheter un ouvrage", 
		 "Afficher le chiffre de ventes", 	 
		 "Terminer"};

	private Librairie librairie;  // les données et opérations de la librairir
	/**
	 * Lie la classe d'interaction textuelle avec l'objet librairie
	 * contenant les données et opérations pour la librairie
	 * @param li donnees et opérations de la libairie
	 */
	public ApplicationTexte(Librairie li) {
		this.librairie=li;
	}	
	/**
	 * Affiche les opérations disponibles
	 */
	private void afficheChoixOps() {
		System.out.println("Operations disponibles: ");
	    for (int i=0; i<operation.length; i++){
	          System.out.println((i+1)+". "+ operation[i]);
	    }
	}
	/**
	 * Implante l'opération 1 du menu. Saisit les données pour la recherche d'un ouvrage par titre
	 * et auteur et affiche les résultats de cette recherche.
	 */
	private void afficheRechercheOuvrage() {
		Livre l = ApplicationTexte.lireLivreRecherche();
		Livre o = librairie.getOuvrageTitreAuteur(l);
		if (o==null) {
			System.out.println(" ==> Ce livre n'est pas au catalogue.\n");
		} else {
			System.out.print("  ==> Résultat de la recherche: ");
			System.out.println(o.toString()+"\n");
		}
	}
	/**
	 * Retourne un entier lu au clavier compris dans l'intervalle 
	 * [inf,sup].
	 * Affiche {@param invite} pour inviter à la saisie et
	 * {@param err} si saisie en dehors de l'intervalle.
	 */
	public static int lireInt(int inf, int sup, String invite, String err){
		int x;
		while (true){
			try {
				System.out.print(invite);
				x =Terminal.lireInt();
				if (x<inf || x > sup)
					System.out.println(err);
				else return x;
			} catch(TerminalException e) {
				System.out.println("Entrez un nombre entier. Recommencez!");
			}
		}
	}
	 /**
	  *  Retourne un double lu au clavier et supérieur à inf 
	  */
	  public static double lireDou(double inf, String invite) {
	    return -1;
	   }
	/**
	 * Retourne un entier lu au clavier compris dans l'intervalle d'opérations proposées.
	 * @return
	 */
	 private int lireChoix() {
		return lireInt(1,operation.length,"Votre choix? ", "No. d'opératon invalide.");
	 }
	 /**
	  * Implante l'opération de vente d'un ouvrage: lit au clavier les données de recherche
	  * et quantité souhaité, effectue la vente si quantité suffisante en stock et met à jour
	  * le stock et le chiffre de ventes puis affiche le montant à payer. 
	  * ATTENTION: cette méthode contient au moins un bug!
	  */
	 private void afficheVente() {
		 // A MODIFIER : CONTIENT UN BUG
		 Livre o = ApplicationTexte.lireLivreRecherche();
		 int quantReq = 
				 ApplicationTexte.lireInt(1, 30, "Quantité souhaité? ", "Quantité invalide! ");
		 int quantStock = 10000;
		 if (quantStock < quantReq) {
			 System.out.print("Vente impossible: quantité en stock insuffisante:");
			 System.out.println(quantStock+ " exemplaires en stock...");
		 } else {
			 double aPayer = librairie.realiseVente(o, quantReq);
			 System.out.println("  ==> Montant à payer= "+ aPayer);
			 System.out.println("  ==> Vente enregistrée ");
		 }
	 }
	 /**
	  * Implante la boucle d'interactions qui éffectue les 
	  * opérations proposées à l'utilisateur. 
	  */
	public void boucleInteraction() {
		boolean fin=false;
		while (!fin) {
			afficheChoixOps();
			int choix=lireChoix();
			try {
				if (choix==1) {		
					afficheRechercheOuvrage();
				}else if (choix==2) {
					Livre l = ApplicationTexte.lireLivre();
					librairie.ajoutExemplaires(l);
					System.out.println("  ==> Entrée en stock enregistrée. \n");
				}else if (choix==3) {
					afficheVente();
				} else if (choix==4){
					System.out.println(" ==>  Chiffre courant de ventes: "+ 
				        librairie.getChiffreVentes()+"\n");
				} else {
					fin=true;
					System.out.println("*** Au revoir ****");
				}
			}catch(IllegalArgumentException e) {
				System.out.println("** Argument négatif: ERREUR INTERNE (ne devrait pas arriver)! \n");
			}catch(StockError e) {
				e.printErr();   // En théorie, on ne devrait jamais exécuter ceci.
			}
		}
	}

	/**
	 * Lit et retourne les données pour la recherche d'un ouvrage (sans prix ni quantite).
	 * Retourne le livre correspondant avec prix et quantité fixés à 0. 
	 * @return
	 */
	public static Livre lireLivreRecherche() {
		System.out.print("Titre? ");
		String t = Terminal.lireString();
		System.out.print("Auteur? ");
		String a = Terminal.lireString();
		return new Livre(t,a,0,0);
	}

	/**
	 * Lit et retourne les données pour la création d'un livre.
	 */
	public static Livre lireLivre() {
		System.out.print("Titre? ");
		String t = Terminal.lireString();
		System.out.print("Auteur? ");
		String a = Terminal.lireString();
		int n = lireInt(1, 30, "Nombre d'exemplaires? ", "Quantité invalide! Recommencez. ");
		double p = lireDou(0,"Prix? ");
		return new Livre(t,a,p,n);
	}
}
