package proj18;
import javax.swing.*;

import java.awt.Dimension;
import java.awt.image.*;


/**
 * @author François Barthélemy
 * 
 * Classe dont les instances sont des fenêtres affichées à l'écran
 * contenant une image.
 *
 */
public class Afficheur extends JFrame{
	private int[] tab;
	private JPanel jp;
	
	/**
	 * @param pixels l'image à afficher
	 */
	public Afficheur(Pixel[][] pixels){
		int width, height;
		width = pixels.length;
		height = pixels[0].length;
		BufferedImage bim = new BufferedImage(width, height,
				BufferedImage.TYPE_INT_ARGB);
		int[] pixtab = arrayFromPix(pixels);
		tab = ( (DataBufferInt) bim.getRaster()
				.getDataBuffer() ).getData();
		System.arraycopy(pixtab, 0, tab, 0, pixtab.length);
		jp = new ImagePanel(bim);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		jp.setPreferredSize(new Dimension(bim.getWidth(),bim.getHeight()));
		this.add(jp);
		this.pack();
		this.setVisible(true);
	}
	/**
	 * Méthode servant à afficher une nouvelle image dans la feneêtre.
	 * 
	 * Cette image doit avoir les mêmes dimensions que celle donnée en 
	 * paramètre au constructeur lors de la création de l'objet sur lequel
	 * la méthode est appelée.
	 * @param pixels l'image à afficher
	 * @throws IndexOutOfBoundsException parfois levée si pixels n'a pas
	 * la même dimension que l'image précédemment affichée par l'objet.
	 */
	public void update(Pixel[][] pixels){
		int[] pixtab = arrayFromPix(pixels);
		System.arraycopy(pixtab, 0, tab, 0, pixtab.length);
		jp.revalidate();
		jp.repaint();
	}
	private int[] arrayFromPix(Pixel[][] pixels){
		int[] res = new int[pixels.length*pixels[0].length];
		for (int col = 0; col< pixels.length; col++){
			for (int lig=0; lig<pixels[0].length; lig++){
				res[pixels.length*lig+col] = intFromPixel(pixels[col][lig]);
			}
		}
		return res;
	}
	private int intFromPixel(Pixel pix){
		int res = pix.getAlpha();
		res = (((res<<8) + pix.getRed()<< 8) + pix.getGreen());
		return (res<<8) + pix.getBlue();
	}
	
	/** Méthode qui ferme la fenêtre.
	 * 
	 */
	public void fermer(){
		this.dispose();
	}

}
